/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.asn1.ASN1OctetString;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.GSSAPIBindRequestProperties;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SASLBindRequest;
import com.unboundid.ldap.sdk.SASLHelper;
import com.unboundid.ldap.sdk.SASLQualityOfProtection;
import com.unboundid.ldap.sdk.ToCodeArgHelper;
import com.unboundid.ldap.sdk.ToCodeHelper;
import com.unboundid.util.Debug;
import com.unboundid.util.DebugType;
import com.unboundid.util.InternalUseOnly;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.Configuration;
import javax.security.auth.login.LoginContext;
import javax.security.sasl.RealmCallback;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.NOT_THREADSAFE)
public final class GSSAPIBindRequest
extends SASLBindRequest
implements CallbackHandler,
PrivilegedExceptionAction<Object> {
    public static final String GSSAPI_MECHANISM_NAME = "GSSAPI";
    private static final String PROPERTY_KDC_ADDRESS = "java.security.krb5.kdc";
    private static final String PROPERTY_REALM = "java.security.krb5.realm";
    private static final String PROPERTY_CONFIG_FILE = "java.security.auth.login.config";
    private static final String PROPERTY_SUBJECT_CREDS_ONLY = "javax.security.auth.useSubjectCredsOnly";
    private static final String DEFAULT_CONFIG_FILE = StaticUtils.getSystemProperty("java.security.auth.login.config");
    private static final String DEFAULT_KDC_ADDRESS = StaticUtils.getSystemProperty("java.security.krb5.kdc");
    private static final String DEFAULT_REALM = StaticUtils.getSystemProperty("java.security.krb5.realm");
    private static final long serialVersionUID = 2511890818146955112L;
    private final ASN1OctetString password;
    private final AtomicReference<LDAPConnection> conn;
    private final boolean enableGSSAPIDebugging;
    private final Boolean isInitiator;
    private final boolean refreshKrb5Config;
    private final boolean renewTGT;
    private final boolean requireCachedCredentials;
    private final boolean useKeyTab;
    private final boolean useSubjectCredentialsOnly;
    private final boolean useTicketCache;
    private int messageID;
    private final List<SASLQualityOfProtection> allowedQoP;
    private final List<String> unhandledCallbackMessages;
    private Set<String> suppressedSystemProperties;
    private final String authenticationID;
    private final String authorizationID;
    private final String configFilePath;
    private final String jaasClientName;
    private final String kdcAddress;
    private final String keyTabPath;
    private final String realm;
    private final String saslClientServerName;
    private final String servicePrincipalProtocol;
    private final String ticketCachePath;

    public GSSAPIBindRequest(String authenticationID, String password) throws LDAPException {
        this(new GSSAPIBindRequestProperties(authenticationID, password), new Control[0]);
    }

    public GSSAPIBindRequest(String authenticationID, byte[] password) throws LDAPException {
        this(new GSSAPIBindRequestProperties(authenticationID, password), new Control[0]);
    }

    public GSSAPIBindRequest(String authenticationID, String password, Control[] controls) throws LDAPException {
        this(new GSSAPIBindRequestProperties(authenticationID, password), controls);
    }

    public GSSAPIBindRequest(String authenticationID, byte[] password, Control[] controls) throws LDAPException {
        this(new GSSAPIBindRequestProperties(authenticationID, password), controls);
    }

    public GSSAPIBindRequest(String authenticationID, String authorizationID, String password, String realm, String kdcAddress, String configFilePath) throws LDAPException {
        this(new GSSAPIBindRequestProperties(authenticationID, authorizationID, new ASN1OctetString(password), realm, kdcAddress, configFilePath), new Control[0]);
    }

    public GSSAPIBindRequest(String authenticationID, String authorizationID, byte[] password, String realm, String kdcAddress, String configFilePath) throws LDAPException {
        this(new GSSAPIBindRequestProperties(authenticationID, authorizationID, new ASN1OctetString(password), realm, kdcAddress, configFilePath), new Control[0]);
    }

    public GSSAPIBindRequest(String authenticationID, String authorizationID, String password, String realm, String kdcAddress, String configFilePath, Control[] controls) throws LDAPException {
        this(new GSSAPIBindRequestProperties(authenticationID, authorizationID, new ASN1OctetString(password), realm, kdcAddress, configFilePath), controls);
    }

    public GSSAPIBindRequest(String authenticationID, String authorizationID, byte[] password, String realm, String kdcAddress, String configFilePath, Control[] controls) throws LDAPException {
        this(new GSSAPIBindRequestProperties(authenticationID, authorizationID, new ASN1OctetString(password), realm, kdcAddress, configFilePath), controls);
    }

    public GSSAPIBindRequest(GSSAPIBindRequestProperties gssapiProperties, Control ... controls) throws LDAPException {
        super(controls);
        Validator.ensureNotNull(gssapiProperties);
        this.authenticationID = gssapiProperties.getAuthenticationID();
        this.password = gssapiProperties.getPassword();
        this.realm = gssapiProperties.getRealm();
        this.allowedQoP = gssapiProperties.getAllowedQoP();
        this.kdcAddress = gssapiProperties.getKDCAddress();
        this.jaasClientName = gssapiProperties.getJAASClientName();
        this.saslClientServerName = gssapiProperties.getSASLClientServerName();
        this.servicePrincipalProtocol = gssapiProperties.getServicePrincipalProtocol();
        this.enableGSSAPIDebugging = gssapiProperties.enableGSSAPIDebugging();
        this.useKeyTab = gssapiProperties.useKeyTab();
        this.useSubjectCredentialsOnly = gssapiProperties.useSubjectCredentialsOnly();
        this.useTicketCache = gssapiProperties.useTicketCache();
        this.requireCachedCredentials = gssapiProperties.requireCachedCredentials();
        this.refreshKrb5Config = gssapiProperties.refreshKrb5Config();
        this.renewTGT = gssapiProperties.renewTGT();
        this.keyTabPath = gssapiProperties.getKeyTabPath();
        this.ticketCachePath = gssapiProperties.getTicketCachePath();
        this.isInitiator = gssapiProperties.getIsInitiator();
        this.suppressedSystemProperties = gssapiProperties.getSuppressedSystemProperties();
        this.unhandledCallbackMessages = new ArrayList<String>(5);
        this.conn = new AtomicReference();
        this.messageID = -1;
        String authzID = gssapiProperties.getAuthorizationID();
        this.authorizationID = authzID == null ? null : authzID;
        String cfgPath = gssapiProperties.getConfigFilePath();
        this.configFilePath = cfgPath == null ? (DEFAULT_CONFIG_FILE == null ? GSSAPIBindRequest.getConfigFilePath(gssapiProperties) : DEFAULT_CONFIG_FILE) : cfgPath;
    }

    @Override
    public String getSASLMechanismName() {
        return GSSAPI_MECHANISM_NAME;
    }

    public String getAuthenticationID() {
        return this.authenticationID;
    }

    public String getAuthorizationID() {
        return this.authorizationID;
    }

    public String getPasswordString() {
        if (this.password == null) {
            return null;
        }
        return this.password.stringValue();
    }

    public byte[] getPasswordBytes() {
        if (this.password == null) {
            return null;
        }
        return this.password.getValue();
    }

    public String getRealm() {
        return this.realm;
    }

    public List<SASLQualityOfProtection> getAllowedQoP() {
        return this.allowedQoP;
    }

    public String getKDCAddress() {
        return this.kdcAddress;
    }

    public String getConfigFilePath() {
        return this.configFilePath;
    }

    public String getServicePrincipalProtocol() {
        return this.servicePrincipalProtocol;
    }

    public boolean refreshKrb5Config() {
        return this.refreshKrb5Config;
    }

    public boolean useKeyTab() {
        return this.useKeyTab;
    }

    public String getKeyTabPath() {
        return this.keyTabPath;
    }

    public boolean useTicketCache() {
        return this.useTicketCache;
    }

    public boolean requireCachedCredentials() {
        return this.requireCachedCredentials;
    }

    public String getTicketCachePath() {
        return this.ticketCachePath;
    }

    public boolean renewTGT() {
        return this.renewTGT;
    }

    public boolean useSubjectCredentialsOnly() {
        return this.useSubjectCredentialsOnly;
    }

    public Boolean getIsInitiator() {
        return this.isInitiator;
    }

    public Set<String> getSuppressedSystemProperties() {
        return this.suppressedSystemProperties;
    }

    public boolean enableGSSAPIDebugging() {
        return this.enableGSSAPIDebugging;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getConfigFilePath(GSSAPIBindRequestProperties properties) throws LDAPException {
        try {
            File f = File.createTempFile("GSSAPIBindRequest-JAAS-Config-", ".conf");
            f.deleteOnExit();
            PrintWriter w = new PrintWriter(new FileWriter(f));
            try {
                Class<?> sunModuleClass = Class.forName("com.sun.security.auth.module.Krb5LoginModule");
                if (sunModuleClass != null) {
                    GSSAPIBindRequest.writeSunJAASConfig(w, properties);
                    String string = f.getAbsolutePath();
                    w.close();
                    return string;
                }
            }
            catch (ClassNotFoundException cnfe) {
                Debug.debugException(cnfe);
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            try {
                Class<?> ibmModuleClass = Class.forName("com.ibm.security.auth.module.Krb5LoginModule");
                if (ibmModuleClass == null) throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_GSSAPI_CANNOT_CREATE_JAAS_CONFIG.get(LDAPMessages.ERR_GSSAPI_NO_SUPPORTED_JAAS_MODULE.get()));
                GSSAPIBindRequest.writeIBMJAASConfig(w, properties);
                return f.getAbsolutePath();
            }
            catch (ClassNotFoundException cnfe) {
                Debug.debugException(cnfe);
            }
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_GSSAPI_CANNOT_CREATE_JAAS_CONFIG.get(LDAPMessages.ERR_GSSAPI_NO_SUPPORTED_JAAS_MODULE.get()));
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            throw le;
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_GSSAPI_CANNOT_CREATE_JAAS_CONFIG.get(StaticUtils.getExceptionMessage(e)), e);
        }
    }

    private static void writeSunJAASConfig(PrintWriter w, GSSAPIBindRequestProperties p) {
        w.println(p.getJAASClientName() + " {");
        w.println("  com.sun.security.auth.module.Krb5LoginModule required");
        w.println("  client=true");
        if (p.getIsInitiator() != null) {
            w.println("  isInitiator=" + p.getIsInitiator());
        }
        if (p.refreshKrb5Config()) {
            w.println("  refreshKrb5Config=true");
        }
        if (p.useKeyTab()) {
            w.println("  useKeyTab=true");
            if (p.getKeyTabPath() != null) {
                w.println("  keyTab=\"" + p.getKeyTabPath() + '\"');
            }
        }
        if (p.useTicketCache()) {
            w.println("  useTicketCache=true");
            w.println("  renewTGT=" + p.renewTGT());
            w.println("  doNotPrompt=" + p.requireCachedCredentials());
            String ticketCachePath = p.getTicketCachePath();
            if (ticketCachePath != null) {
                w.println("  ticketCache=\"" + ticketCachePath + '\"');
            }
        } else {
            w.println("  useTicketCache=false");
        }
        if (p.enableGSSAPIDebugging()) {
            w.println(" debug=true");
        }
        w.println("  ;");
        w.println("};");
    }

    private static void writeIBMJAASConfig(PrintWriter w, GSSAPIBindRequestProperties p) {
        w.println(p.getJAASClientName() + " {");
        w.println("  com.ibm.security.auth.module.Krb5LoginModule required");
        if (p.getIsInitiator() == null || p.getIsInitiator().booleanValue()) {
            w.println("  credsType=initiator");
        } else {
            w.println("  credsType=acceptor");
        }
        if (p.refreshKrb5Config()) {
            w.println("  refreshKrb5Config=true");
        }
        if (p.useKeyTab()) {
            w.println("  useKeyTab=true");
            if (p.getKeyTabPath() != null) {
                w.println("  keyTab=\"" + p.getKeyTabPath() + '\"');
            }
        }
        if (p.useTicketCache()) {
            String ticketCachePath = p.getTicketCachePath();
            if (ticketCachePath == null) {
                if (p.requireCachedCredentials()) {
                    w.println("  useDefaultCcache=true");
                }
            } else {
                File f = new File(ticketCachePath);
                String path = f.getAbsolutePath().replace('\\', '/');
                w.println("  useCcache=\"file://" + path + '\"');
            }
        } else {
            w.println("  useDefaultCcache=false");
        }
        if (p.enableGSSAPIDebugging()) {
            w.println(" debug=true");
        }
        w.println("  ;");
        w.println("};");
    }

    @Override
    protected BindResult process(LDAPConnection connection, int depth) throws LDAPException {
        if (!this.conn.compareAndSet(null, connection)) {
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_GSSAPI_MULTIPLE_CONCURRENT_REQUESTS.get());
        }
        this.setProperty(PROPERTY_CONFIG_FILE, this.configFilePath);
        this.setProperty(PROPERTY_SUBJECT_CREDS_ONLY, String.valueOf(this.useSubjectCredentialsOnly));
        if (Debug.debugEnabled(DebugType.LDAP)) {
            Debug.debug(Level.CONFIG, DebugType.LDAP, "Using config file property java.security.auth.login.config = '" + this.configFilePath + "'.");
            Debug.debug(Level.CONFIG, DebugType.LDAP, "Using subject creds only property javax.security.auth.useSubjectCredsOnly = '" + this.useSubjectCredentialsOnly + "'.");
        }
        if (this.kdcAddress == null) {
            if (DEFAULT_KDC_ADDRESS == null) {
                this.clearProperty(PROPERTY_KDC_ADDRESS);
                if (Debug.debugEnabled(DebugType.LDAP)) {
                    Debug.debug(Level.CONFIG, DebugType.LDAP, "Clearing kdcAddress property 'java.security.krb5.kdc'.");
                }
            } else {
                this.setProperty(PROPERTY_KDC_ADDRESS, DEFAULT_KDC_ADDRESS);
                if (Debug.debugEnabled(DebugType.LDAP)) {
                    Debug.debug(Level.CONFIG, DebugType.LDAP, "Using default kdcAddress property java.security.krb5.kdc = '" + DEFAULT_KDC_ADDRESS + "'.");
                }
            }
        } else {
            this.setProperty(PROPERTY_KDC_ADDRESS, this.kdcAddress);
            if (Debug.debugEnabled(DebugType.LDAP)) {
                Debug.debug(Level.CONFIG, DebugType.LDAP, "Using kdcAddress property java.security.krb5.kdc = '" + this.kdcAddress + "'.");
            }
        }
        if (this.realm == null) {
            if (DEFAULT_REALM == null) {
                this.clearProperty(PROPERTY_REALM);
                if (Debug.debugEnabled(DebugType.LDAP)) {
                    Debug.debug(Level.CONFIG, DebugType.LDAP, "Clearing realm property 'java.security.krb5.realm'.");
                }
            } else {
                this.setProperty(PROPERTY_REALM, DEFAULT_REALM);
                if (Debug.debugEnabled(DebugType.LDAP)) {
                    Debug.debug(Level.CONFIG, DebugType.LDAP, "Using default realm property java.security.krb5.realm = '" + DEFAULT_REALM + "'.");
                }
            }
        } else {
            this.setProperty(PROPERTY_REALM, this.realm);
            if (Debug.debugEnabled(DebugType.LDAP)) {
                Debug.debug(Level.CONFIG, DebugType.LDAP, "Using realm property java.security.krb5.realm = '" + this.realm + "'.");
            }
        }
        try {
            Configuration.getConfiguration().refresh();
        }
        catch (Exception e) {
            Debug.debugException(e);
        }
        try {
            LoginContext context;
            try {
                context = new LoginContext(this.jaasClientName, this);
                context.login();
            }
            catch (Exception e) {
                Debug.debugException(e);
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_GSSAPI_CANNOT_INITIALIZE_JAAS_CONTEXT.get(StaticUtils.getExceptionMessage(e)), e);
            }
            try {
                BindResult e = (BindResult)Subject.doAs(context.getSubject(), this);
                return e;
            }
            catch (Exception e) {
                Debug.debugException(e);
                if (e instanceof LDAPException) {
                    throw (LDAPException)e;
                }
                throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_GSSAPI_AUTHENTICATION_FAILED.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
        finally {
            this.conn.set(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @InternalUseOnly
    public Object run() throws LDAPException {
        SaslClient saslClient;
        this.unhandledCallbackMessages.clear();
        LDAPConnection connection = this.conn.get();
        HashMap<String, String> saslProperties = new HashMap<String, String>(StaticUtils.computeMapCapacity(2));
        saslProperties.put("javax.security.sasl.qop", SASLQualityOfProtection.toString(this.allowedQoP));
        saslProperties.put("javax.security.sasl.server.authentication", "true");
        try {
            String serverName = this.saslClientServerName;
            if (serverName == null) {
                serverName = connection.getConnectedAddress();
            }
            String[] mechanisms = new String[]{GSSAPI_MECHANISM_NAME};
            saslClient = Sasl.createSaslClient(mechanisms, this.authorizationID, this.servicePrincipalProtocol, serverName, saslProperties, this);
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPException(ResultCode.LOCAL_ERROR, LDAPMessages.ERR_GSSAPI_CANNOT_CREATE_SASL_CLIENT.get(StaticUtils.getExceptionMessage(e)), e);
        }
        SASLHelper helper = new SASLHelper(this, connection, GSSAPI_MECHANISM_NAME, saslClient, this.getControls(), this.getResponseTimeoutMillis(connection), this.unhandledCallbackMessages);
        try {
            BindResult bindResult = helper.processSASLBind();
            return bindResult;
        }
        finally {
            this.messageID = helper.getMessageID();
        }
    }

    @Override
    public GSSAPIBindRequest getRebindRequest(String host, int port) {
        try {
            GSSAPIBindRequestProperties gssapiProperties = new GSSAPIBindRequestProperties(this.authenticationID, this.authorizationID, this.password, this.realm, this.kdcAddress, this.configFilePath);
            gssapiProperties.setAllowedQoP(this.allowedQoP);
            gssapiProperties.setServicePrincipalProtocol(this.servicePrincipalProtocol);
            gssapiProperties.setUseTicketCache(this.useTicketCache);
            gssapiProperties.setRequireCachedCredentials(this.requireCachedCredentials);
            gssapiProperties.setRenewTGT(this.renewTGT);
            gssapiProperties.setUseSubjectCredentialsOnly(this.useSubjectCredentialsOnly);
            gssapiProperties.setTicketCachePath(this.ticketCachePath);
            gssapiProperties.setEnableGSSAPIDebugging(this.enableGSSAPIDebugging);
            gssapiProperties.setJAASClientName(this.jaasClientName);
            gssapiProperties.setSASLClientServerName(this.saslClientServerName);
            gssapiProperties.setSuppressedSystemProperties(this.suppressedSystemProperties);
            return new GSSAPIBindRequest(gssapiProperties, this.getControls());
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    @Override
    @InternalUseOnly
    public void handle(Callback[] callbacks) throws UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof NameCallback) {
                ((NameCallback)callback).setName(this.authenticationID);
                continue;
            }
            if (callback instanceof PasswordCallback) {
                if (this.password == null) {
                    throw new UnsupportedCallbackException(callback, LDAPMessages.ERR_GSSAPI_NO_PASSWORD_AVAILABLE.get());
                }
                ((PasswordCallback)callback).setPassword(this.password.stringValue().toCharArray());
                continue;
            }
            if (callback instanceof RealmCallback) {
                RealmCallback rc = (RealmCallback)callback;
                if (this.realm == null) {
                    this.unhandledCallbackMessages.add(LDAPMessages.ERR_GSSAPI_REALM_REQUIRED_BUT_NONE_PROVIDED.get(rc.getPrompt()));
                    continue;
                }
                rc.setText(this.realm);
                continue;
            }
            if (Debug.debugEnabled(DebugType.LDAP)) {
                Debug.debug(Level.WARNING, DebugType.LDAP, "Unexpected GSSAPI SASL callback of type " + callback.getClass().getName());
            }
            this.unhandledCallbackMessages.add(LDAPMessages.ERR_GSSAPI_UNEXPECTED_CALLBACK.get(callback.getClass().getName()));
        }
    }

    @Override
    public int getLastMessageID() {
        return this.messageID;
    }

    @Override
    public GSSAPIBindRequest duplicate() {
        return this.duplicate(this.getControls());
    }

    @Override
    public GSSAPIBindRequest duplicate(Control[] controls) {
        try {
            GSSAPIBindRequestProperties gssapiProperties = new GSSAPIBindRequestProperties(this.authenticationID, this.authorizationID, this.password, this.realm, this.kdcAddress, this.configFilePath);
            gssapiProperties.setAllowedQoP(this.allowedQoP);
            gssapiProperties.setServicePrincipalProtocol(this.servicePrincipalProtocol);
            gssapiProperties.setUseTicketCache(this.useTicketCache);
            gssapiProperties.setRequireCachedCredentials(this.requireCachedCredentials);
            gssapiProperties.setRenewTGT(this.renewTGT);
            gssapiProperties.setRefreshKrb5Config(this.refreshKrb5Config);
            gssapiProperties.setUseKeyTab(this.useKeyTab);
            gssapiProperties.setKeyTabPath(this.keyTabPath);
            gssapiProperties.setUseSubjectCredentialsOnly(this.useSubjectCredentialsOnly);
            gssapiProperties.setTicketCachePath(this.ticketCachePath);
            gssapiProperties.setEnableGSSAPIDebugging(this.enableGSSAPIDebugging);
            gssapiProperties.setJAASClientName(this.jaasClientName);
            gssapiProperties.setSASLClientServerName(this.saslClientServerName);
            gssapiProperties.setIsInitiator(this.isInitiator);
            gssapiProperties.setSuppressedSystemProperties(this.suppressedSystemProperties);
            GSSAPIBindRequest bindRequest = new GSSAPIBindRequest(gssapiProperties, controls);
            bindRequest.setResponseTimeoutMillis(this.getResponseTimeoutMillis(null));
            return bindRequest;
        }
        catch (Exception e) {
            Debug.debugException(e);
            return null;
        }
    }

    private void clearProperty(String name) {
        if (!this.suppressedSystemProperties.contains(name)) {
            StaticUtils.clearSystemProperty(name);
        }
    }

    private void setProperty(String name, String value) {
        if (!this.suppressedSystemProperties.contains(name)) {
            StaticUtils.setSystemProperty(name, value);
        }
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("GSSAPIBindRequest(authenticationID='");
        buffer.append(this.authenticationID);
        buffer.append('\'');
        if (this.authorizationID != null) {
            buffer.append(", authorizationID='");
            buffer.append(this.authorizationID);
            buffer.append('\'');
        }
        if (this.realm != null) {
            buffer.append(", realm='");
            buffer.append(this.realm);
            buffer.append('\'');
        }
        buffer.append(", qop='");
        buffer.append(SASLQualityOfProtection.toString(this.allowedQoP));
        buffer.append('\'');
        if (this.kdcAddress != null) {
            buffer.append(", kdcAddress='");
            buffer.append(this.kdcAddress);
            buffer.append('\'');
        }
        if (this.isInitiator != null) {
            buffer.append(", isInitiator=");
            buffer.append(this.isInitiator);
        }
        buffer.append(", jaasClientName='");
        buffer.append(this.jaasClientName);
        buffer.append("', configFilePath='");
        buffer.append(this.configFilePath);
        buffer.append("', servicePrincipalProtocol='");
        buffer.append(this.servicePrincipalProtocol);
        buffer.append("', enableGSSAPIDebugging=");
        buffer.append(this.enableGSSAPIDebugging);
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            buffer.append(", controls={");
            for (int i = 0; i < controls.length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                buffer.append(controls[i]);
            }
            buffer.append('}');
        }
        buffer.append(')');
    }

    @Override
    public void toCode(List<String> lineList, String requestID, int indentSpaces, boolean includeProcessing) {
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, "GSSAPIBindRequestProperties", requestID + "RequestProperties", "new GSSAPIBindRequestProperties", ToCodeArgHelper.createString(this.authenticationID, "Authentication ID"), ToCodeArgHelper.createString("---redacted-password---", "Password"));
        if (this.authorizationID != null) {
            ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.setAuthorizationID", ToCodeArgHelper.createString(this.authorizationID, null));
        }
        if (this.realm != null) {
            ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.setRealm", ToCodeArgHelper.createString(this.realm, null));
        }
        ArrayList<String> qopValues = new ArrayList<String>(3);
        for (SASLQualityOfProtection qop : this.allowedQoP) {
            qopValues.add("SASLQualityOfProtection." + qop.name());
        }
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.setAllowedQoP", ToCodeArgHelper.createRaw(qopValues, null));
        if (this.kdcAddress != null) {
            ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.setKDCAddress", ToCodeArgHelper.createString(this.kdcAddress, null));
        }
        if (this.jaasClientName != null) {
            ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.setJAASClientName", ToCodeArgHelper.createString(this.jaasClientName, null));
        }
        if (this.configFilePath != null) {
            ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.setConfigFilePath", ToCodeArgHelper.createString(this.configFilePath, null));
        }
        if (this.saslClientServerName != null) {
            ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.setSASLClientServerName", ToCodeArgHelper.createString(this.saslClientServerName, null));
        }
        if (this.servicePrincipalProtocol != null) {
            ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.setServicePrincipalProtocol", ToCodeArgHelper.createString(this.servicePrincipalProtocol, null));
        }
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.setRefreshKrb5Config", ToCodeArgHelper.createBoolean(this.refreshKrb5Config, null));
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.setUseKeyTab", ToCodeArgHelper.createBoolean(this.useKeyTab, null));
        if (this.keyTabPath != null) {
            ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.setKeyTabPath", ToCodeArgHelper.createString(this.keyTabPath, null));
        }
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.setUseSubjectCredentialsOnly", ToCodeArgHelper.createBoolean(this.useSubjectCredentialsOnly, null));
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.setUseTicketCache", ToCodeArgHelper.createBoolean(this.useTicketCache, null));
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.setRequireCachedCredentials", ToCodeArgHelper.createBoolean(this.requireCachedCredentials, null));
        if (this.ticketCachePath != null) {
            ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.setTicketCachePath", ToCodeArgHelper.createString(this.ticketCachePath, null));
        }
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.setRenewTGT", ToCodeArgHelper.createBoolean(this.renewTGT, null));
        if (this.isInitiator != null) {
            ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.setIsInitiator", ToCodeArgHelper.createBoolean(this.isInitiator, null));
        }
        if (this.suppressedSystemProperties != null && !this.suppressedSystemProperties.isEmpty()) {
            ArrayList<ToCodeArgHelper> suppressedArgs = new ArrayList<ToCodeArgHelper>(this.suppressedSystemProperties.size());
            for (String s : this.suppressedSystemProperties) {
                suppressedArgs.add(ToCodeArgHelper.createString(s, null));
            }
            ToCodeHelper.generateMethodCall(lineList, indentSpaces, "List<String>", requestID + "SuppressedProperties", "Arrays.asList", suppressedArgs);
            ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.setSuppressedSystemProperties", ToCodeArgHelper.createRaw(requestID + "SuppressedProperties", null));
        }
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, null, null, requestID + "RequestProperties.setEnableGSSAPIDebugging", ToCodeArgHelper.createBoolean(this.enableGSSAPIDebugging, null));
        ArrayList<ToCodeArgHelper> constructorArgs = new ArrayList<ToCodeArgHelper>(2);
        constructorArgs.add(ToCodeArgHelper.createRaw(requestID + "RequestProperties", null));
        Control[] controls = this.getControls();
        if (controls.length > 0) {
            constructorArgs.add(ToCodeArgHelper.createControlArray(controls, "Bind Controls"));
        }
        ToCodeHelper.generateMethodCall(lineList, indentSpaces, "GSSAPIBindRequest", requestID + "Request", "new GSSAPIBindRequest", constructorArgs);
        if (includeProcessing) {
            StringBuilder buffer = new StringBuilder();
            for (int i = 0; i < indentSpaces; ++i) {
                buffer.append(' ');
            }
            String indent = buffer.toString();
            lineList.add("");
            lineList.add(indent + "try");
            lineList.add(indent + '{');
            lineList.add(indent + "  BindResult " + requestID + "Result = connection.bind(" + requestID + "Request);");
            lineList.add(indent + "  // The bind was processed successfully.");
            lineList.add(indent + '}');
            lineList.add(indent + "catch (LDAPException e)");
            lineList.add(indent + '{');
            lineList.add(indent + "  // The bind failed.  Maybe the following will " + "help explain why.");
            lineList.add(indent + "  // Note that the connection is now likely in " + "an unauthenticated state.");
            lineList.add(indent + "  ResultCode resultCode = e.getResultCode();");
            lineList.add(indent + "  String message = e.getMessage();");
            lineList.add(indent + "  String matchedDN = e.getMatchedDN();");
            lineList.add(indent + "  String[] referralURLs = e.getReferralURLs();");
            lineList.add(indent + "  Control[] responseControls = " + "e.getResponseControls();");
            lineList.add(indent + '}');
        }
    }
}

